/*
 *
 * PSX Peripheral Bus Library Config Tools v1.4 17/01/00 Richard Davies 
 * <mailto:richard@debaser.force9.co.uk>
 *
 * Revision History:
 * v1.4 - 17/01/00 Win32 / Win32 DLL support and bug fixes
 * v1.3 - 21/12/99 Linux support and bug fixes
 * v1.0 - 17/07/99 Initial release.
 *
 */


#include "psxpbcfg.h"


void psxpb_cfg(int* base, int* conport, int* tap, int* delay)
{
   char filename[13];
   char filestr[128];
   FILE *f;
   
   /* read 'psxpblib.cfg' file */
   strcpy(filename, "psxpblib.cfg");

   f = fopen(filename, "rb");
      
   /* if the config file exists */
   if (f != NULL)
   {
      /* open it */
      while(!feof(f))
      {
         if(fgets(filestr, 128, f) == NULL)
            break;
         if (strstr(filestr, "lpt = ") != NULL)
         {
            switch (atoi(filestr + 6))
            {
               case 1: *base = LPT1_BASE; break;
               case 2: *base = LPT2_BASE; break;
               case 3: *base = LPT3_BASE; break;
               default: break;
            }
         }
         else if (strstr(filestr, "con = ") != NULL)
         {
            if ((atoi(filestr + 6) > 0) && (atoi(filestr + 6) <= PSX_MAX_CONPORTS))
            {
               *conport = atoi(filestr + 6);               
            }
         }            
         else if (strstr(filestr, "tap = ") != NULL)
         {
            switch (filestr[6])
            {
               case 'a' : case 'A' : *tap = 1; break;
               case 'b' : case 'B' : *tap = 2; break;
               case 'c' : case 'C' : *tap = 3; break;
               case 'd' : case 'D' : *tap = 4; break;
               default: break;
            }
         }
         else if (strstr(filestr, "del = ") != NULL)
         {
            if ((atoi(filestr + 6) > 0) && (atoi(filestr + 6) <= PSX_MAX_DELAY))
            {
               *delay = atoi(filestr + 6);                  
            }
         }
      }
   }
   else
   {
      /* create it */
      f = fopen(filename, "wb");
      
      if (f)
      {
         fputs("[PSX Peripheral Bus Lib v1.4 Config]\n\n", f);
         fputs("# valid 'lpt' parallel port values are 1 to 3\n", f);
         fprintf(f, "# valid 'con' controller port values are 1 to %d\n", PSX_MAX_CONPORTS);
         fprintf(f, "# valid 'tap' controller port tap values are A to %c\n", PSX_MAX_TAPS + ('A' - 1));
         fprintf(f, "# valid 'del' scan delay values are 1 to %d\n\n", PSX_MAX_DELAY);
         fputs("lpt = -1\n", f);
         fputs("con = -1\n", f);
         fputs("tap = A\n", f);
         fputs("del = 3\n", f);
      }
   }
   
   fclose(f);
}

void psxpb_cmd(int* base, int* conport, int* tap, int* delay, int argc, char *argv[])
{ 
   int i;

   /* read command line switches */
   if(argc > 1)
   {
      for (i = 1;i < argc; i ++)
      {
         if ((argv[i][0] == '-') && ((i + 1) < argc))
         {
            if (stricmp(argv[i], "-lpt") == 0)
            {
               switch (atoi(argv[i+1]))
               {
                  case 1: *base = LPT1_BASE; i++; break;
                  case 2: *base = LPT2_BASE; i++; break;
                  case 3: *base = LPT3_BASE; i++; break;
                  default: break;
               }
            }
            else if (stricmp(argv[i], "-con") == 0)
            {
               if ((atoi(argv[i+1]) > 0) && (atoi(argv[i+1]) <= PSX_MAX_CONPORTS))
               {
                  *conport = atoi(argv[i+1]);               
                  i++;
               }
            }            
            else if (stricmp(argv[i], "-tap") == 0)
            {
               switch (argv[i+1][0])
               {
                  case 'a' : case 'A' : *tap = 1; i++; break;
                  case 'b' : case 'B' : *tap = 2; i++; break;
                  case 'c' : case 'C' : *tap = 3; i++; break;
                  case 'd' : case 'D' : *tap = 4; i++; break;
                  default: break;
               }
            }
            else if (stricmp(argv[i], "-del") == 0)
            {
               if ((atoi(argv[i+1]) > 0) && (atoi(argv[i+1]) <= PSX_MAX_DELAY))
               {
                  *delay = atoi(argv[i+1]);                  
                  i++;
               }
            }
         }
      }
   }
}
